/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin.inv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.items.crafting.NpcShapedRecipes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SlotCrafting.class}, priority=499)
public class SlotCraftingMixin {
    @Final
    @Shadow
    private InventoryCrafting field_75239_a;
    @Final
    @Shadow
    private EntityPlayer field_75238_b;
    @Shadow
    private int field_75237_g;

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    public void npcs$onTake(EntityPlayer player, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        cir.cancel();
        InventoryCraftResult inventorycraftresult = (InventoryCraftResult)((Slot)this).field_75224_c;
        IRecipe recipe = inventorycraftresult.func_193055_i();
        if (recipe == null && (recipe = CraftingManager.func_192413_b((InventoryCrafting)this.field_75239_a, (World)player.field_70170_p)) != null) {
            inventorycraftresult.func_193056_a(recipe);
        }
        boolean ignoreDamage = false;
        boolean ignoreNBT = false;
        if (recipe instanceof INpcRecipe) {
            if (!((Availability)((INpcRecipe)recipe).getAvailability()).isAvailable(player)) {
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("item.craft.not.availability", new Object[0]));
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    player.field_71070_bA.func_75142_b();
                }
                cir.setReturnValue((Object)ItemStack.field_190927_a);
                return;
            }
            ignoreDamage = ((INpcRecipe)recipe).getIgnoreDamage();
            ignoreNBT = ((INpcRecipe)recipe).getIgnoreNBT();
        }
        this.npcs$onCrafting(stack);
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        NonNullList nonnulllist = CraftingManager.func_180303_b((InventoryCrafting)this.field_75239_a, (World)player.field_70170_p);
        ForgeHooks.setCraftingPlayer(null);
        Map<Object, Object> slotToCount = new HashMap();
        if (recipe instanceof ShapedRecipes) {
            slotToCount = this.npcs$processShapedRecipe((ShapedRecipes)recipe, ignoreDamage, ignoreNBT);
        } else if (recipe instanceof ShapelessRecipes) {
            slotToCount = this.npcs$processShapelessRecipe((ShapelessRecipes)recipe, ignoreDamage, ignoreNBT);
        }
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack craftStack = this.field_75239_a.func_70301_a(i);
            ItemStack extraStack = (ItemStack)nonnulllist.get(i);
            int count = 1;
            if (slotToCount.containsKey(i)) {
                count = (Integer)slotToCount.get(i);
            }
            if (!craftStack.func_190926_b()) {
                this.field_75239_a.func_70298_a(i, count);
                craftStack = this.field_75239_a.func_70301_a(i);
            }
            if (extraStack.func_190926_b()) continue;
            if (craftStack.func_190926_b()) {
                this.field_75239_a.func_70299_a(i, extraStack);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)craftStack, (ItemStack)extraStack) && ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)extraStack)) {
                extraStack.func_190917_f(craftStack.func_190916_E());
                this.field_75239_a.func_70299_a(i, extraStack);
                continue;
            }
            if (player.field_71071_by.func_70441_a(extraStack)) continue;
            player.func_71019_a(extraStack, false);
        }
        player.field_71070_bA.func_75142_b();
        cir.setReturnValue((Object)stack);
    }

    @Unique
    protected void npcs$onCrafting(ItemStack stack) {
        if (this.field_75237_g > 0) {
            stack.func_77980_a(this.field_75238_b.field_70170_p, this.field_75238_b, this.field_75237_g);
            FMLCommonHandler.instance().firePlayerCraftingEvent(this.field_75238_b, stack, (IInventory)this.field_75239_a);
        }
        this.field_75237_g = 0;
        InventoryCraftResult inventorycraftresult = (InventoryCraftResult)((Slot)this).field_75224_c;
        IRecipe irecipe = inventorycraftresult.func_193055_i();
        if (irecipe != null && !irecipe.func_192399_d()) {
            this.field_75238_b.func_192021_a(Collections.singletonList(irecipe));
            inventorycraftresult.func_193056_a(null);
        }
    }

    @Unique
    public Map<Integer, Integer> npcs$processShapedRecipe(ShapedRecipes recipe, boolean ignoreDamage, boolean ignoreNBT) {
        HashMap<Integer, Integer> slotToCount = new HashMap<Integer, Integer>();
        int recipeWidth = recipe.func_192403_f();
        int recipeHeight = recipe.func_192404_g();
        NonNullList ingredients = recipe.func_192400_c();
        if (recipe instanceof NpcShapedRecipes) {
            Object[] objs = ((NpcShapedRecipes)recipe).getGrid();
            recipeWidth = (Integer)objs[0];
            recipeHeight = (Integer)objs[1];
            ingredients = (NonNullList)objs[2];
        }
        int ings = -1;
        for (int r = 0; r < 2; ++r) {
            for (int slotW = 0; slotW <= this.field_75239_a.func_174922_i() - recipeWidth; ++slotW) {
                for (int slotH = 0; slotH <= this.field_75239_a.func_174923_h() - recipeHeight; ++slotH) {
                    ings = recipeWidth * recipeHeight;
                    for (int i = 0; i < this.field_75239_a.func_174922_i(); ++i) {
                        for (int j = 0; j < this.field_75239_a.func_174923_h(); ++j) {
                            ItemStack ingStack;
                            int k = i - slotW;
                            int l = j - slotH;
                            Ingredient ingredient = Ingredient.field_193370_a;
                            if (k >= 0 && l >= 0 && k < recipeWidth && l < recipeHeight) {
                                ingredient = r == 1 ? (Ingredient)ingredients.get(recipeWidth - k - 1 + l * recipeWidth) : (Ingredient)ingredients.get(k + l * recipeWidth);
                            }
                            if (ingredient.apply(this.field_75239_a.func_70463_b(i, j)) && (ingStack = this.npcs$apply(ingredient, this.field_75239_a.func_70463_b(i, j), ignoreDamage, ignoreNBT)) != null) {
                                --ings;
                                slotToCount.put(i + j * this.field_75239_a.func_174922_i(), ingStack.func_190916_E());
                            }
                            if (ings == 0) break;
                        }
                        if (ings == 0) break;
                    }
                    if (ings == 0) break;
                }
                if (ings == 0) break;
            }
            if (ings == 0) break;
        }
        if (ings != 0) {
            slotToCount.clear();
        }
        return slotToCount;
    }

    @Unique
    public Map<Integer, Integer> npcs$processShapelessRecipe(ShapelessRecipes recipe, boolean ignoreDamage, boolean ignoreNBT) {
        NonNullList ingredients = recipe.func_192400_c();
        HashMap<Integer, Integer> slotToCount = new HashMap<Integer, Integer>();
        HashMap<ItemStack, Integer> recipeStacks = new HashMap<ItemStack, Integer>();
        ArrayList<Integer> founds = new ArrayList<Integer>();
        for (Ingredient ingredient : ingredients) {
            block1: for (ItemStack ingredientStack : ingredient.func_193365_a()) {
                for (int i = 0; i < this.field_75239_a.func_70302_i_(); ++i) {
                    ItemStack itemInSlot;
                    if (founds.contains(i) || NoppesUtilServer.IsItemStackNull(itemInSlot = this.field_75239_a.func_70301_a(i)) || !NoppesUtilPlayer.compareItems(itemInSlot, ingredientStack, ignoreDamage, ignoreNBT)) continue;
                    boolean added = true;
                    for (ItemStack recipeStack : recipeStacks.keySet()) {
                        if (!NoppesUtilPlayer.compareItems(recipeStack, itemInSlot, ignoreDamage, ignoreNBT)) continue;
                        added = false;
                        recipeStacks.put(recipeStack, (Integer)recipeStacks.get(recipeStack) + ingredientStack.func_190916_E());
                        break;
                    }
                    if (added) {
                        recipeStacks.put(ingredientStack, ingredientStack.func_190916_E());
                    }
                    founds.add(i);
                    continue block1;
                }
            }
        }
        block4: for (int i = 0; i < this.field_75239_a.func_70302_i_(); ++i) {
            ItemStack itemInSlot = this.field_75239_a.func_70301_a(i);
            for (ItemStack recipeStack : recipeStacks.keySet()) {
                int count = (Integer)recipeStacks.get(recipeStack);
                if (count <= 0 || !NoppesUtilPlayer.compareItems(recipeStack, itemInSlot, ignoreDamage, ignoreNBT)) continue;
                if (itemInSlot.func_190916_E() >= count) {
                    slotToCount.put(i, count);
                    recipeStacks.put(recipeStack, 0);
                    continue block4;
                }
                slotToCount.put(i, itemInSlot.func_190916_E());
                recipeStacks.put(recipeStack, count - itemInSlot.func_190916_E());
                continue block4;
            }
        }
        return slotToCount;
    }

    @Unique
    public ItemStack npcs$apply(@Nullable Ingredient ingredient, @Nullable ItemStack stack, boolean ignoreDamage, boolean ignoreNBT) {
        if (stack == null || ingredient == null) {
            return null;
        }
        ItemStack[] stacks = ingredient.func_193365_a();
        if (stacks.length == 0 && stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (ItemStack ingStack : stacks) {
            if (ingStack.func_77973_b() != stack.func_77973_b() || ingStack.func_190926_b() || stack.func_190926_b() || !NoppesUtilPlayer.compareItems(stack, ingStack, ignoreDamage, ignoreNBT) || ingStack.func_190916_E() > stack.func_190916_E()) continue;
            return ingStack;
        }
        return null;
    }
}

